package gov.va.genisis2.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.service.IStudyApprovalService;

/**
 * @author 586338
 * @author Getaneh Kassahun
 *
 */
@Service
public class StudyApprovalService implements IStudyApprovalService {

	private static final Logger LOGGER = LoggerFactory.getLogger(StudyApprovalService.class);
	
	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	/**
	 * /** This method is used to createStudyApproval.
	 * 
	 * @param studyApproval
	 *            The studyApproval.
	 * @return int This returns studyApproval id.
	 */
	@Override
	public int createStudyApproval(StudyApproval studyApproval) throws GenisisServiceException {
		try {
			return studyApprovalDao.createStudyApproval(studyApproval);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on createStudyApproval", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to updateStudyApproval.
	 * 
	 * @param studyApproval
	 *            The studyApproval.
	 * @return int This returns studyApproval id.
	 */
	@Override
	public int updateStudyApproval(StudyApproval studyApproval) throws GenisisServiceException {
		try {
			return studyApprovalDao.updateStudyApproval(studyApproval);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on updateStudyApproval", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getStudyApprovalsByID.
	 * 
	 * @param id
	 *            The id.
	 * @return StudyApproval This returns StudyApproval.
	 */
	@Override
	public StudyApproval getStudyApprovalsByID(int id) throws GenisisServiceException {
		try {
			return studyApprovalDao.getStudyApprovalsByID(id);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred while querring  getStudyApprovalsByID", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getStudyApprovalsByUID.
	 * 
	 * @param uid
	 *            The uid.
	 * @return this returns list of StudyApproval.
	 */
	@Override
	public List<StudyApproval> getStudyApprovalsByUID(String uid) throws GenisisServiceException {
		try {
			return studyApprovalDao.getStudyApprovalsByUID(uid);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred while querring  getStudyApprovalsByUID", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getStudyApprovals.
	 * 
	 * @return this returns list of StudyApproval.
	 */
	@Override
	public List<StudyApproval> getStudyApprovals() throws GenisisServiceException {
		try {
			return studyApprovalDao.getStudyApprovals();
		} catch (Exception ex) {
			LOGGER.error("Exception occurred while querring  getStudyApprovals", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * @param studyApprovalDao
	 *            the studyApprovalDao to set
	 */
	public void setStudyApprovalDao(IStudyApprovalDao studyApprovalDao) {
		this.studyApprovalDao = studyApprovalDao;
	}
}
